<?php

/**
  * Get settings
  *
  * @return array
*/
function mts_testimonials_get_settings() {
	global $mts_testimonials_admin;

	$settings = $mts_testimonials_admin->get_settings( true );

	return $settings;
}

/**
  * Display rating stars
  *
  * @param integer $rating
  * @return void
*/
if( !function_exists( 'mts_testimonials_get_rating_html' ) ) {
	function mts_testimonials_get_rating_html( $rating ) {
		global $mts_testimonials;
		$output = $mts_testimonials->stars_input('mts_testimonials_rating', $rating, 'mts-testimonials-rating', 'mts-testimonials-frontend-rating', true);

		return $output;
	}
}
/**
  * Get testimonials from the database
  *
  * @param string $id testimonial id
  * @param integer $status testimonial post status
  * @param integer $order_by order by
  * @return void
*/
if( !function_exists( 'mts_get_testimonial' ) ) {
	function mts_get_testimonial( $num, $cat, $status, $order_by = 'DESC', $ids = array() ) {
		if (empty($ids)) {
			$tax_query = array();
			if ($cat) {
				$tax_query = array(
				    array(
				      'taxonomy' => 'mts_testimonials_category',
				      'field' => 'id',
				      'terms' => $cat
				    )
				);
			}
			$rows = get_posts(array(
				'post_type' => 'mts_testimonials',
				'posts_per_page' => $num,
				'tax_query' => $tax_query,
				'orderby' => $order_by
			));
		} else {
			$rows = get_posts(array(
				'post_type' => 'mts_testimonials',
				'posts_per_page' => -1,
				'post__in' => $ids,
				'orderby' => 'post__in'
			));
		}


		return $rows;
	}
}


/**
  * Get testimonial layout
  *
  * @param array $args
  * @return string
*/
if( !function_exists( 'mts_get_testimonial_layout' ) ) {
	function mts_get_testimonial_layout( $args ) {
		$output = '';
		if (empty($args['layout'])) $args['layout'] = 'bubble_grid';
		if (empty($args['posts'])) $args['posts'] = array();
		$template = MTS_TESTIMONIALS_PATH . '/layouts/' . preg_replace( "/[^a-zA-Z0-9_-]+/", "", $args['layout'] ) . '.php';
		if (!file_exists($template)) {
			$template = MTS_TESTIMONIALS_PATH . '/layouts/bubble_grid.php';
		}
		ob_start();
		include($template);
		$output = ob_get_clean();

		return apply_filters( 'mts_testimonials_get_layout', $output);
	}
}
